;--------------------------------
;Include

  !include "MUI.nsh"

;--------------------------------
;Define

!define PRODUCT_GUID "{DB3ED071-8BE8-4E2D-BE04-993F1FDBDA35}"
!define PRODUCT_NAME "SmartKey Drivers"
!define PRODUCT_DIR "Aladdin"
!define PRODUCT_MANUFACTURER "Aladdin Knowledge Systems Ltd."
!define PRODUCT_COPYRIGHT "Aladdin Knowledge Systems Ltd. (c) 1985 - 2008. All rights reserved."
!define PRODUCT_MAJOR_VERSION 12
!define PRODUCT_MINOR_VERSION 0
!define PRODUCT_VERSION 0x0C000000
!define PRODUCT_YEAR 2008
!define PRODUCT_UNINSTALL "uninstall.exe"

;--------------------------------
;General

  SetCompressor /SOLID lzma
  Name "${PRODUCT_NAME}"
  OutFile "SmartKeyDriversInstaller.exe"
  InstallDir "$PROGRAMFILES\${PRODUCT_DIR}\${PRODUCT_NAME}"
  InstallDirRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "InstallLocation"
  BrandingText "${PRODUCT_MANUFACTURER}"
  ShowInstDetails nevershow
  ShowUninstDetails nevershow
  XPStyle on
  SetOverwrite ifnewer

  VIAddVersionKey "ProductName" "${PRODUCT_NAME}"
  VIAddVersionKey "Comments" ""
  VIAddVersionKey "CompanyName" "${PRODUCT_MANUFACTURER}"
  VIAddVersionKey "LegalTrademarks" "${PRODUCT_MANUFACTURER}"
  VIAddVersionKey "LegalCopyright" "${PRODUCT_COPYRIGHT}"
  VIAddVersionKey "FileDescription" "${PRODUCT_NAME}"
  VIAddVersionKey "FileVersion" "${PRODUCT_MAJOR_VERSION}.${PRODUCT_MINOR_VERSION}.0.0"
  VIProductVersion "${PRODUCT_MAJOR_VERSION}.${PRODUCT_MINOR_VERSION}.0.0"

;--------------------------------
;Interface Configuration

  !define MUI_ABORTWARNING
  !define MUI_HEADERIMAGE
  !define MUI_HEADERIMAGE_BITMAP "logo.bmp"
  !define MUI_HEADERIMAGE_BITMAP_NOSTRETCH
  !define MUI_HEADERIMAGE_UNBITMAP "logo.bmp"
  !define MUI_HEADERIMAGE_UNBITMAP_NOSTRETCH
  !define MUI_HEADERIMAGE_RIGHT
  !define MUI_ICON "Data\smartkey.ico"
  !define MUI_UNICON "Data\smartkey.ico"
  !define MUI_WELCOMEFINISHPAGE_BITMAP "bar.bmp"
  !define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "bar.bmp"
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------
;Functions

!macro Clean un
Function ${un}Clean
  ;File
  Delete "$INSTDIR\eu*.sys"
  Delete "$INSTDIR\eu*.exe"
  Delete "$INSTDIR\eu*.inf"
  Delete "$INSTDIR\eu*.cat"
  Delete "$INSTDIR\psapi.dll"
  Delete "$INSTDIR\skey*.dll"
  Delete "$INSTDIR\skey*.log"
  Delete "$INSTDIR\skey*.inf"
  Delete "$INSTDIR\skey*.sys"
  Delete "$INSTDIR\smartkey.ico"
  Delete "$INSTDIR\usbdrv.inf"
  Delete "$INSTDIR\usbdrv.sys"

  Delete "$INSTDIR\${PRODUCT_UNINSTALL}"

  RMDir "$INSTDIR"
FunctionEnd
!macroend

!insertmacro Clean ""
!insertmacro Clean "un."

Function CheckReturn

IntCmp $0 0 returnP0
IntCmp $0 1 returnP1
IntCmp $0 2 returnP2
IntCmp $0 -1 returnN1
IntCmp $0 -2 returnN2
IntCmp $0 -3 returnN3
IntCmp $0 -4 returnN4
Goto returnNU
returnP0:
  ; SKEYINST_OK
  Return
returnP1:
  ; SKEYINST_WARNING_MUST_REBOOT
  SetRebootFlag true
  Return
returnP2:
  ; SKEYINST_WARNING_MUST_INSERT
  Return
returnNU:  
returnN1:
  ; SKEYINST_ERROR_FAIL
  MessageBox MB_OK|MB_ICONSTOP "Fatal error occurred in the ${PRODUCT_NAME} installation.$\n$\nYou can find a detailed log in:$\n$INSTDIR\skeyinst.log"
  SetErrorLevel 2
  Abort "Operation failed."
  Return
returnN2:
  ; SKEYINST_ERROR_UNSUPPORTED
  ; Ignore error if unsupported
  Return
returnN3:
  ; SKEYINST_ERROR_WAIT
  MessageBox MB_OK|MB_ICONSTOP "Another installation is in progress. Wait and retry."
  SetErrorLevel 2
  Abort "Another installation is in progress. Wait and retry."
  Return
returnN4:
  ; SKEYINST_ERROR_ADMIN
  MessageBox MB_OK|MB_ICONSTOP "You must be an Administrator to install ${PRODUCT_NAME}."
  SetErrorLevel 2
  Abort "You must be administrator."
  Return
FunctionEnd

Function un.CheckReturn

IntCmp $0 0 returnC0
IntCmp $0 1 returnC1
  SetErrorLevel 2
  Return
returnC0:
  Return
returnC1:
  ; SKEYINST_WARNING_MUST_REBOOT
  SetRebootFlag true
  Return
FunctionEnd

;--------------------------------
;Installer Sections

Function .onInit
  ;Version
  ReadRegDWORD $R0 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "Version"
  IfErrors firstinstall
  IntCmp $R0 ${PRODUCT_VERSION} same upgrade downgrade

same:
  Return

upgrade:
  Return

downgrade:
  IntOp $R1 $R0 >> 16
  IntOp $R1 $R1 & 0xFF
  IntOp $R0 $R0 >> 24
  MessageBox MB_OK|MB_ICONEXCLAMATION "A more recent version ($R0.$R1) of ${PRODUCT_NAME} is already installed." /SD IDOK
  Abort
  Return

firstinstall:
  Return

FunctionEnd

Section "" 
  Call Clean

  SetOutPath "$INSTDIR"

  File "Data\*.*"
  
  SetPluginUnload alwaysoff

  StrCpy $1 "$INSTDIR\skeyinst.log"
  System::Call 'skeyinst::SkeyLogFile(tr1.) i.r0'

  DetailPrint "Installing USB drivers..."
  System::Call 'skeyinst::SkeyInstallUSB() i.r0'
  Call CheckReturn
  
  DetailPrint "Installing Parallel drivers..."
  System::Call 'skeyinst::SkeyInstallPar() i.r0'
  Call CheckReturn
  
  DetailPrint "Installing GSS drivers..."
  System::Call 'skeyinst::SkeyInstallGSS2() i.r0'
  Call CheckReturn

  DetailPrint "Installing VDD drivers..."
  System::Call 'skeyinst::SkeyInstallVDD() i.r0 ?u'
  Call CheckReturn

  SetPluginUnload manual
  System::Free 0

  DetailPrint "Updating Registry..."

  ;Uninstall
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "DisplayName" "${PRODUCT_DIR} ${PRODUCT_NAME}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "UninstallString" '"$INSTDIR\${PRODUCT_UNINSTALL}"'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "InstallLocation" '$INSTDIR'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "DisplayIcon" '$INSTDIR\${PRODUCT_UNINSTALL}'
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "Publisher" "${PRODUCT_MANUFACTURER}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "HelpLink" "http://www.eutronsec.com/"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "Contact" "helpdesk@eutronsec.com"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "DisplayVersion" "${PRODUCT_MAJOR_VERSION}.${PRODUCT_MINOR_VERSION}"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "Version" ${PRODUCT_VERSION}
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}" "NoRepair" 1
  WriteUninstaller "$INSTDIR\${PRODUCT_UNINSTALL}"

  DetailPrint "Completed"
SectionEnd

;--------------------------------
;Uninstaller Section

Section "Uninstall"
  ; Set the directory where the DLL resides
  SetOutPath "$INSTDIR"

  SetPluginUnload alwaysoff

  DetailPrint "Removing USB drivers..."
  System::Call 'skeyinst::SkeyUnInstallUSB() i.r0'
  Call un.CheckReturn

  DetailPrint "Removing Parallel drivers..."
  System::Call 'skeyinst::SkeyUnInstallPar() i.r0'
  Call un.CheckReturn

  DetailPrint "Removing GSS drivers..."
  System::Call 'skeyinst::SkeyUnInstallGSS2() i.r0'
  Call un.CheckReturn

  DetailPrint "Removing VDD drivers..."
  System::Call 'skeyinst::SkeyUnInstallVDD() i.r0 ?u'
  Call un.CheckReturn

  SetPluginUnload manual
  System::Free 0

  ; Set a directory which is not deleted
  SetOutPath "$DESKTOP"

  Call un.Clean

  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_GUID}"
SectionEnd
